<?php
header('Content-Type: application/json');
session_start();
include 'conexao.php';

// Recebe e decodifica o JSON
$data = json_decode(file_get_contents('php://input'), true);

if (!is_array($data)) {
    echo json_encode(['success' => false, 'message' => 'Dados inválidos.']);
    exit;
}

try {
    // Começa uma transação para garantir que todas as operações sejam bem-sucedidas ou nenhuma seja
    $conn->begin_transaction();

    // Limpa todas as atribuições existentes para re-alocá-las
    $conn->query("DELETE FROM atribuicoes_horario");

    // Prepara a inserção para evitar SQL Injection
    $stmt = $conn->prepare("INSERT INTO atribuicoes_horario (turma, professor, dia, hora_id, disciplina_id, professor_id) VALUES (?, ?, ?, ?, ?, ?)");

    foreach ($data as $item) {
        $turma = $item['turma'];
        $dia = $item['dia'];
        $hora_id = intval($item['hora']);
        $disciplina_id = intval($item['disciplina_id']);
        $professor_id = intval($item['professor_id']);

        // A lógica de associação de nomes (a partir dos IDs) precisaria de mais dados.
        // Neste exemplo, vamos salvar os IDs, que são mais úteis para o BD.
        // A lógica de exibição no frontend cuida dos nomes.
        $turma_nome = explode(" - ", $turma)[1]; // Exemplo de como pegar só o nome
        $professor_nome = ''; // Você precisaria buscar o nome do professor aqui

        $stmt->bind_param("sssiis", $turma, $professor_nome, $dia, $hora_id, $disciplina_id, $professor_id);
        $stmt->execute();
    }

    $conn->commit();
    echo json_encode(['success' => true, 'message' => 'Horário atualizado com sucesso.']);

} catch (Exception $e) {
    $conn->rollback();
    echo json_encode(['success' => false, 'message' => 'Erro ao salvar o horário. ' . $e->getMessage()]);
}

$conn->close();
?>